import { Component, OnInit, Input } from '@angular/core';
import { MvpServices } from '../../../../services/mvp-services';

import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';

@Component({
  selector: 'app-mvp-add-definition',
  templateUrl: './mvp-add-definition.component.html',
  styleUrls: ['./mvp-add-definition.component.scss']
})
export class MvpAddDefinitionComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
	@Input() mvpObject;
	@Input() definition;
  @select(['system', 'focusedElement']) focusedElement;
  onHoverSubmit: boolean
  constructor(
  	private ngRedux: NgRedux<IAppState>,
  	public mvpServices: MvpServices) {
  }

  ngOnInit() {
  }

  getState() {
  	return this.ngRedux.getState();
  }

  addDefinitionToMvpObject() {
    if (this.definition != null) {
      var definitionInput = this.definition.trim();
    }
  	if (definitionInput != null && definitionInput.length > 0) {
    	this.mvpObject.object = definitionInput;
    	this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }

}
